import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class IOPanel extends JPanel
{
	private static final long serialVersionUID = 1L;

	private JTextArea IOTextArea; // contains IOProgramString, which can be edited here if the simulation is not running
	private JScrollPane IOTextAreaScrollPane; // internal use, for adding scroll bars to IOTextArea

	public IOPanel(MainWindow MainWindow)
	{
		// text area
		IOTextArea = new JTextArea(35, 60);
		IOTextArea.setFont(new Font("Courier New", Font.PLAIN, 20));
		IOTextArea.setBounds(10, 30, 400, 600);
		IOTextArea.setText("");
		IOTextArea.addKeyListener(new KeyListener()
		{
			private boolean IsKeyToBeForwarded(KeyEvent e)
			{
				switch (e.getKeyCode())
				{
				case KeyEvent.VK_F1:
				case KeyEvent.VK_F2:
				case KeyEvent.VK_F3:
				case KeyEvent.VK_F4:
				case KeyEvent.VK_F5:
				case KeyEvent.VK_F6:
				case KeyEvent.VK_F9:
				case KeyEvent.VK_F10:
				case KeyEvent.VK_F11:
				case KeyEvent.VK_F12:
					return true;
				}
				return false;
			}

			@Override
			public void keyPressed(KeyEvent e)
			{
				if (IsKeyToBeForwarded(e))
					MainWindow.keyPressed(e);
			}

			@Override
			public void keyReleased(KeyEvent e)
			{
				if (IsKeyToBeForwarded(e))
					MainWindow.keyReleased(e);
			}

			@Override
			public void keyTyped(KeyEvent e)
			{
				if (IsKeyToBeForwarded(e))
					MainWindow.keyTyped(e);
			}
		});
		IOTextArea.addFocusListener(new FocusListener()
		{
			@Override
			public void focusGained(FocusEvent arg0)
			{
				// TODO Auto-generated method stub

			}

			@Override
			public void focusLost(FocusEvent arg0)
			{
				// TODO Auto-generated method stub

				MainWindow.focusLost(arg0); // we DO need this to finally make KeyEventProcessor release keys
			}
		});

		// scroll bars for text area
		IOTextAreaScrollPane = new JScrollPane(IOTextArea);
		IOTextAreaScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		IOTextAreaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

		// the actual IOPanel (this object) containing the text area with its scroll bars
		this.add(IOTextAreaScrollPane); // add ScrollPane, NOT TextArea (tested)!
		this.setSize(400, 600);
		this.setVisible(false);
	}

	public String GetIOProgramString()
	{
		return IOTextArea.getText();
	}

	public JTextArea GetIOTextArea()
	{
		return IOTextArea;
	}

	@Override
	public void requestFocus()
	{
		IOTextArea.requestFocus();
	}

	public void SetIOProgramString(String IOProgramString)
	{
		if (IOProgramString.length() > 1000000)
		{
			System.out.println("warning in IOPanel.SetIOProgramString(): passed value not useful!");
			IOProgramString = IOProgramString.substring(0, 1000000) + "[...]"; // limit length to ~1 MB
		}
		IOTextArea.setText(IOProgramString);
	}
}
